/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.cuisinedelight.content.item;

import dev.xkmc.cuisinedelight.content.block.CuisineSkilletBlockEntity;
import dev.xkmc.cuisinedelight.content.item.CuisineSkilletItem;
import dev.xkmc.cuisinedelight.content.logic.CookingData;
import dev.xkmc.cuisinedelight.init.data.LangData;
import dev.xkmc.cuisinedelight.init.registrate.CDItems;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class SpatulaItem
extends Item {
    public static final int ANIM_TIME = 20;

    public SpatulaItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack spatulaStack = player.m_21120_(hand);
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack skilletStack = player.m_21120_(otherHand);
        if (!skilletStack.m_150930_((Item)CDItems.SKILLET.get())) {
            return InteractionResultHolder.m_19098_((Object)spatulaStack);
        }
        CookingData data = CuisineSkilletItem.getData(skilletStack);
        if (data != null) {
            if (!level.m_5776_()) {
                data.stir(level.m_46467_(), SpatulaItem.getReduction(spatulaStack));
                CuisineSkilletItem.setData(skilletStack, data);
                player.m_36335_().m_41524_((Item)this, 20);
                player.m_36335_().m_41524_((Item)CDItems.SKILLET.get(), 20);
            } else {
                CuisineSkilletItem.playSound(player, level, (SoundEvent)ModSounds.BLOCK_SKILLET_ADD_FOOD.get());
            }
            return InteractionResultHolder.m_19090_((Object)spatulaStack);
        }
        return InteractionResultHolder.m_19100_((Object)spatulaStack);
    }

    private static int getReduction(ItemStack stack) {
        return stack.getEnchantmentLevel(Enchantments.f_44985_) > 0 ? 20 : 0;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level level = ctx.m_43725_();
        Player player = ctx.m_43723_();
        BlockEntity blockEntity = level.m_7702_(ctx.m_8083_());
        if (blockEntity instanceof CuisineSkilletBlockEntity) {
            CuisineSkilletBlockEntity be = (CuisineSkilletBlockEntity)blockEntity;
            if (be.cookingData.contents.size() > 0) {
                if (!level.m_5776_()) {
                    be.stir(level.m_46467_(), SpatulaItem.getReduction(ctx.m_43722_()));
                    if (player != null) {
                        player.m_36335_().m_41524_((Item)CDItems.SPATULA.get(), 20);
                    }
                } else if (player != null) {
                    CuisineSkilletItem.playSound(player, level, (SoundEvent)ModSounds.BLOCK_SKILLET_SIZZLE.get());
                }
            }
        }
        return InteractionResult.PASS;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44985_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            list.add((Component)LangData.ENCH_SILK.get(new Object[0]));
        } else {
            list.add((Component)LangData.ENCH_SHIFT.get(new Object[0]));
        }
    }
}

